
/*
 * File:		main.c
 * Purpose:		Main process
 *
 */

#include "m5282evb.h"
#include "environment.h"
#include "march.h"
				
#define SIZE 32768 					
/********************************************************************/
	
void main (void)
{
   	int i;
   	int result;

	printf("\nMCF5282 Init Done\n");
	
	/*Configure PORT D as GPIO*/	
	MCF5282_GPIO_PBCDPAR = (0x0);
	COMMENT("Configure PORTD as GPIO outputs\n");
   	WR8(MCF5282_GPIO_DDRD, 0xFF);
   	COMMENT("Initialize PORTD to 0 - used as FAIL\n");
   	WR8(MCF5282_GPIO_PORTD, 0x00);
	
	/* Test Lower half of RAM */
	result = march ((UINT32 *)(SRAM_ADDRESS), SIZE);
	WR8(MCF5282_GPIO_PORTD, result);
	
	/*Write result to PORT D*/
	
	for (i=0; i<100; i++); /*Keep the result around for a while*/

	switch (result) {
		case MARCHPASS: 
			COMMENT("MARCHPASS.\n");
	    	break;
		case FAILFILL:
			COMMENT("FAILFILL.\n");
	    	break;
		case FAILCOMPL1:
			COMMENT("FAILCOMPL1.\n");
			break;
		case FAILCOMPL2: 
			COMMENT("FAILCOMPL2.\n");
			break;
		case FAILPAT2:   
			COMMENT("FAILCOMPL2.\n");
			break;
		case FAILPAT3:
			COMMENT("FAILPAT3.\n");
			break;
		case FAILCOMPL3:
			COMMENT("FAILCOMPL3.\n");
			break;
		case FAILCOMPL4:
			COMMENT("FAILCOMPL4.\n");
			break;
		case FAILPAT4:
			COMMENT("FAILPAT4.\n");
			break;
		case FAILPAT5:
			COMMENT("FAILPAT5.\n");
			break;
   }
   
   /* Loop forever */
   while(1);
}
/********************************************************************/
__interrupt__
void irq7_handler (void) 
{

	
}


/********************************************************************/
__interrupt__
void swt_handler (void) 
{

	
}